#include <iostream>
#include <algorithm>
#include <vector>
#include <map>
#include <utility>
#define ll long long

using namespace std;

template<typename T>
using vec = vector<T>;

template<typename T>
void input(vec<T>& vref) {
	int i;
	for (i = 1; i < vref.size(); i++)
		cin >> vref[i];
}
vec<int> t;
vec<ll> k;
map<pair<pair<ll, int>, ll>, ll> dp;
ll _nan;

ll func(ll x, ll k, int t) {
	if (t == 1)
		return min(x, k);
	else if (t == 2)
		return max(x, k);
	else
		return x + k;
}

ll querry_response(int l, int r, ll x) {
	vec<ll> partial(r - l + 1);
	int i;
	dp[{ {k[l], t[l]}, x}] = func(x, k[l], t[l]);
	if (dp[{ { k[l], t[l]}, x}] == 0)
		dp[{ { k[l], t[l]}, x}] = _nan;
	partial[0] = dp[{ { k[l], t[l]}, x}];
	ll response = partial[0];
	for (i = l + 1; i <= r; i++) {
		if (dp[{ {k[i], t[i]}, partial[i - l - 1]}] != 0) {
			if (dp[{ {k[i], t[i]}, partial[i - l - 1]}] != _nan)
				response += dp[{ {k[i], t[i]}, partial[i - l - 1]}];
		}
		else {
			partial[i - l] = func(partial[i - l - 1], k[i], t[i]);
			response += partial[i - l];
			if (partial[i - l] == 0)
				dp[{ {k[i], t[i]}, partial[i - l - 1]}] = _nan;
			else
				dp[{ {k[i], t[i]}, partial[i - l - 1]}] = partial[i - l];
		}
	}
	return response;
}

int main() {
	ios_base::sync_with_stdio(false);
	_nan = pow(2, 63) - 1;
	int n;
	cin >> n;
	t.resize(n + 1);
	input(t);
	k.resize(n + 1);
	input(k);
	int q;
	cin >> q;
	int l, r;
	ll x;

	vec<ll> res(q);
	for (int i = 0; i < q; i++) {
		cin >> l >> r >> x;
		res[i] = querry_response(l, r, x);
	}
	for (int i = 0; i < q; i++) {
		cout << res[i] << "\n";
	}
	return EXIT_SUCCESS;
}